import React, { useState, useEffect, useCallback } from 'react';
import { Button } from '@alifd/next';
import "./index.less";
import { MemoryRouter, Route, Switch, useHistory } from 'react-router-dom';

const Home = () => {

  const history = useHistory();

  const visitMenu = (id) => async () => {
    await my.extendApp.pushMenu({
      id,
    });

    if (id) {
      history.push(id)
    }
  }

  return <div>
    Home
    <Button onClick={visitMenu('/a')}> 访问 menuA</Button>
    <Button onClick={visitMenu('/b')}> 访问 menuB</Button>
    <Button onClick={visitMenu('/c')}> 访问 menuC</Button>
  </div>
}

const MenuA = () => {
  return <div>MenuA</div>
}

const MenuB = () => {
  return <div>MenuB</div>
}

const MenuC = () => {
  return <div>MenuC</div>
}

const RootListener = () => {
  const history = useHistory();

  const listenRouteChange = () => {
    my.on('routeChange', (params) => {
      /**
      * 这里的 params 就是路由跳转时携带的参数
      */
      console.log('routeChange params is : ', params);

      const { id } = params;

      if (id) {
        history.push(id)
      }
    });
  }

  useEffect(() => {
    listenRouteChange();

  }, [])

  return null
}

const Root = () => {

  const registerSideBar = async () => {
    await my.extendApp.registerSideBar({
      menuList: [
        {
          label: 'Home',
          id: '/home',
          icon: 'https://gw.alicdn.com/imgextra/i4/O1CN01kar5na1SOb0M40VLY_!!6000000002237-2-tps-40-40.png',
          activeIcon: 'https://gw.alicdn.com/imgextra/i1/O1CN01EUVgZi1zUtm8Hq3Cm_!!6000000006718-2-tps-40-40.png',
        },
        {
          label: 'MenuA',
          id: '/a',
          icon: 'https://gw.alicdn.com/imgextra/i4/O1CN01kar5na1SOb0M40VLY_!!6000000002237-2-tps-40-40.png',
          activeIcon: 'https://gw.alicdn.com/imgextra/i1/O1CN01EUVgZi1zUtm8Hq3Cm_!!6000000006718-2-tps-40-40.png',
        },
        {
          label: 'MenuB',
          id: '/b',
          icon: 'https://gw.alicdn.com/imgextra/i2/O1CN01j0jakG1NXgmqn8qVP_!!6000000001580-2-tps-40-40.png',
          activeIcon: 'https://gw.alicdn.com/imgextra/i2/O1CN014Cy8ZP1u4GfOQAH7v_!!6000000005983-2-tps-40-40.png',
        },
        {
          label: 'MenuC',
          id: '/c',
          icon: 'https://gw.alicdn.com/imgextra/i2/O1CN01UkS7S625WcxtOWbZ1_!!6000000007534-2-tps-40-40.png',
          activeIcon: 'https://gw.alicdn.com/imgextra/i4/O1CN01leZQ3E2A72vBlvP7d_!!6000000008155-2-tps-40-40.png',
        },
      ],
    });

    await my.extendApp.pushMenu({
      id: '/home',
    });
  }


  useEffect(() => {
    registerSideBar();

  }, [])



  return (
    <div>
      <MemoryRouter>
        <RootListener />
        <Switch>
          <Route path="/home" exact component={Home} />
          <Route path="/a" component={MenuA} />
          <Route path="/b" component={MenuB} />
          <Route path="/c" component={MenuC} />
        </Switch>
      </MemoryRouter>
    </div>
  );
};


export default Root;
